% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_surface_background.R
\name{collayer.bg.meancurv}
\alias{collayer.bg.meancurv}
\title{Compute binarized mean curvature surface color layer.}
\usage{
collayer.bg.meancurv(
  subjects_dir,
  subject_id,
  hemi = "both",
  cortex_only = FALSE,
  bin_colors = c("#898989", "#5e5e5e"),
  bin_thresholds = c(0)
)
}
\arguments{
\item{subjects_dir}{character string, the FreeSurfer SUBJECTS_DIR.}

\item{subject_id}{character string, the subject identifier.}

\item{hemi}{character string, one of 'lh', 'rh', or 'both'. The latter will merge the data for both hemis into a single vector.}

\item{cortex_only}{logical, whether to restrict pattern computation to the cortex.}

\item{bin_colors}{vector of two character strings, the two colors to use.}

\item{bin_thresholds}{vector of 1 or 2 double values, the curvature threshold values used to separate gyri from sulci.}
}
\value{
a color layer, i.e., vector of color strings in a hemilist
}
\description{
Compute a binarized mean curvature surface color layer, this is intended as a background color layer. You can merge it with your data layer using \code{\link[fsbrain]{collayers.merge}}.
}
\seealso{
You can plot the return value using \code{\link[fsbrain]{vis.color.on.subject}}.

Other surface color layer: 
\code{\link{collayer.bg}()},
\code{\link{collayer.bg.atlas}()},
\code{\link{collayer.bg.sulc}()},
\code{\link{collayer.from.annot}()},
\code{\link{collayer.from.annotdata}()},
\code{\link{collayer.from.mask.data}()},
\code{\link{collayer.from.morphlike.data}()},
\code{\link{collayers.merge}()}
}
\concept{surface color layer}
