% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optdata.R
\name{download_fsaverage6}
\alias{download_fsaverage6}
\title{Download the FreeSurfer v6 fsaverage6 subject.}
\usage{
download_fsaverage6(accept_freesurfer_license = FALSE)
}
\arguments{
\item{accept_freesurfer_license}{logical, whether you accept the FreeSurfer license for fsaverage, available at https://surfer.nmr.mgh.harvard.edu/fswiki/FreeSurferSoftwareLicense. Defaults to FALSE.}
}
\value{
Named list. The list has entries: "available": vector of strings. The names of the files that are available in the local file cache. You can access them using get_optional_data_file(). "missing": vector of strings. The names of the files that this function was unable to retrieve.
}
\description{
Download some relevant files from the FreeSurfer v6 fsaverage6 subject. The files are subject to the FreeSurfer software license, see parameter 'accept_freesurfer_license' for details. This data is not required for the package to work. If you are working on a machine that has FreeSurfer installed, you already have this data anyways and do not need to download it.
}
\note{
The subject fsaverage6 is a slightly downsampled (low mesh resolution) version of the standard fsaverage. If you never heard about fsaverage6, you do not need it. You will have to manually re-sample your data in FreeSurfer if you want to use it with fsaverage6.
}
