% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Testing.R
\name{Testing}
\alias{Testing}
\title{Testing Class}
\description{
This is a primary classes of fuseMLR. An object from this class
is designed to contain multiple layers, but only one new meta layer.

A Testing object is structured as followed:
\itemize{
\item \link{TestLayer}
\item \link{TestMetaLayer}
}
}
\seealso{
\link{TrainLayer}
}
\section{Super class}{
\code{\link[fuseMLR:HashTable]{fuseMLR::HashTable}} -> \code{Testing}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Testing-new}{\code{Testing$new()}}
\item \href{#method-Testing-print}{\code{Testing$print()}}
\item \href{#method-Testing-getIndIDs}{\code{Testing$getIndIDs()}}
\item \href{#method-Testing-getTestMetaLayer}{\code{Testing$getTestMetaLayer()}}
\item \href{#method-Testing-getIndCol}{\code{Testing$getIndCol()}}
\item \href{#method-Testing-getVerbose}{\code{Testing$getVerbose()}}
\item \href{#method-Testing-getData}{\code{Testing$getData()}}
\item \href{#method-Testing-upset}{\code{Testing$upset()}}
\item \href{#method-Testing-summary}{\code{Testing$summary()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="add2HashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-add2HashTable'><code>fuseMLR::HashTable$add2HashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="checkClassExist"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-checkClassExist'><code>fuseMLR::HashTable$checkClassExist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getFromHashTable'><code>fuseMLR::HashTable$getFromHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getHashTable'><code>fuseMLR::HashTable$getHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getId"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getId'><code>fuseMLR::HashTable$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getKeyClass"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getKeyClass'><code>fuseMLR::HashTable$getKeyClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="removeFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-removeFromHashTable'><code>fuseMLR::HashTable$removeFromHashTable()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Testing-new"></a>}}
\if{latex}{\out{\hypertarget{method-Testing-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Testing$new(id, ind_col, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character}\cr
Testing id.}

\item{\code{ind_col}}{\code{character}
Name of column of individuals IDS in testing data.frame.}

\item{\code{verbose}}{\code{boolean} \cr
Warning messages will be displayed if set to TRUE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Testing-print"></a>}}
\if{latex}{\out{\hypertarget{method-Testing-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Testing$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Testing-getIndIDs"></a>}}
\if{latex}{\out{\hypertarget{method-Testing-getIndIDs}{}}}
\subsection{Method \code{getIndIDs()}}{
Gather individual IDs from all layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Testing$getIndIDs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.frame} containing individuals IDs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Testing-getTestMetaLayer"></a>}}
\if{latex}{\out{\hypertarget{method-Testing-getTestMetaLayer}{}}}
\subsection{Method \code{getTestMetaLayer()}}{
Getter of the meta layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Testing$getTestMetaLayer()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Object from class \link{TestMetaLayer}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Testing-getIndCol"></a>}}
\if{latex}{\out{\hypertarget{method-Testing-getIndCol}{}}}
\subsection{Method \code{getIndCol()}}{
Getter of the individual column name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Testing$getIndCol()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Testing-getVerbose"></a>}}
\if{latex}{\out{\hypertarget{method-Testing-getVerbose}{}}}
\subsection{Method \code{getVerbose()}}{
Getter of the verbose setting.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Testing$getVerbose()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Testing-getData"></a>}}
\if{latex}{\out{\hypertarget{method-Testing-getData}{}}}
\subsection{Method \code{getData()}}{
Retrieve modality-specific prediction data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Testing$getData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{list} containing all (base and meta) models.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Testing-upset"></a>}}
\if{latex}{\out{\hypertarget{method-Testing-upset}{}}}
\subsection{Method \code{upset()}}{
UpSet plot to show an overview of the overlap of individuals across various layers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Testing$upset(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any} \cr
Further parameters to be passed to the the \code{upset} function from package \code{UpSetR}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Testing-summary"></a>}}
\if{latex}{\out{\hypertarget{method-Testing-summary}{}}}
\subsection{Method \code{summary()}}{
Generate testing summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Testing$summary()}\if{html}{\out{</div>}}
}

}
}
