% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainingFunctions.R
\name{createTrainMetaLayer}
\alias{createTrainMetaLayer}
\title{createTrainMetaLayer}
\usage{
createTrainMetaLayer(
  training,
  meta_layer_id,
  lrner_package = NULL,
  lrn_fct,
  param_train_list = list(),
  param_pred_list = list(),
  na_action = "na.impute",
  x_lrn = "x",
  y_lrn = "y",
  object = "object",
  data = "data",
  extract_pred_fct = NULL
)
}
\arguments{
\item{training}{\code{Training} \cr
Training object for storing the created meta-layer.}

\item{meta_layer_id}{\code{character} \cr
ID of the layer to be created.}

\item{lrner_package}{\code{character} \cr
Package name containing the variable selection algorithm function.
Defaults to \code{NULL} if the function exists in the current working environment.}

\item{lrn_fct}{\code{character} \cr
Name of the learning function. The function must accept at least two
parameters: \code{x} (predictors) and \code{y} (response values), and return a model.
If not, use the interface parameters \code{x_lrn} and \code{y_lrn} below to map these
argument names to the original arguments in your function. The returned model
must support the generic \code{predict} function (with arguments \code{object} and \code{data})
to make predictions for new data, and the predictions should be a vector or
a \code{list} containing a vector called \code{predictions} with the predicted values.
If the arguments \code{object} and \code{data} are named differently in your predict
function, use the interface parameters \code{object} and \code{data} below to specify
the original names. See the details below about meta-learners.}

\item{param_train_list}{\code{character} \cr
List of arguments to be passed to \code{lrn_fct}.}

\item{param_pred_list}{\code{list} \cr
List of arguments to be passed to \code{predict} when computing predictions.}

\item{na_action}{\code{character}\cr
Handling of missing values in modality-specific predictions during training.
Set to \code{"na.keep"} to keep missing values, \code{"na.rm"} to remove individuals
with missing values or \code{"na.impute"} to impute missing values in modality-specific
predictions. Only median and mode based imputations are actually handled.
With the \code{"na.keep"} option, ensure that the provided meta-learner can handle missing values.}

\item{x_lrn}{\code{character} \cr
If the argument name used by the provided original function to pass the matrix
of independent variables is not \code{x}, use this argument to specify the name used
in the function.}

\item{y_lrn}{\code{character} \cr
If the argument name used by the provided original function to pass the target
variable is not \code{y}, use this argument to specify the name used in the function.}

\item{object}{\code{character} \cr
The generic function \code{predict} uses a parameter \code{object} to pass a model.
If the corresponding argument is named differently in your predict function, specify the name.}

\item{data}{\code{character} \cr
The generic function \code{predict} uses a parameter \code{data} to pass new data.
If the corresponding argument is named differently in your predict function, specify the name.}

\item{extract_pred_fct}{\verb{character or function} \cr
If the predict function that is called for the model does not return a vector, then
use this argument to specify a (or a name of a) function that can be used to extract vector of predictions.
Defaults to NULL, if predictions are a vector.}
}
\value{
The updated \link{Training} object (with the new layer) is returned.
}
\description{
Creates and store a \link{TrainMetaLayer} on the \link{Training} object passed as argument.
The meta-layer encapsulates the meta-learner and the fold predictions (internally created) of the layer-specific
base models.
}
\details{
Internal meta-learners are available in the package.

The \link{cobra} meta-learner implements the COBRA (COmBined Regression Alternative),
an aggregation method for combining predictions from multiple individual learners (Biau et al. 2014).
This method aims to tune key parameters for achieving optimal predictions
by averaging the target values of similar candidates in the training dataset's predictions.
Only the training points that are sufficiently similar to the test point
(based on the proximity threshold \code{epsilon}) are used for prediction.
If no suitable training points are found, the function returns \code{NA}.

The \link{weightedMeanLearner} evaluates the prediction performance of modality-specific
learners and uses these estimates to weight the base models, aggregating their
predictions accordingly.

The \link{bestLayerLearner} evaluates the prediction performance of modality-specific
learners and returns predictions made by the best learner as the meta-prediction.

Beyond the internal meta-learners, any other learning algorithm can be used.
}
\references{
Fouodo C.J.K, Bleskina M. and Szymczak S. (2024). fuseMLR: An R package for integrative prediction modeling of multi-omics data, paper submitted. \cr
Biau, G., Fischer, A., Guedj, B., & Malley, J. D. (2014). COBRA: A combined regression strategy. The Journal of Multivariate Analysis 46:18-28
}
\seealso{
\link{createTrainLayer}, \link{varSelection}, and \link{fusemlr}.
}
