% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.weightedMeanLearner.R
\name{predict.weightedMeanLearner}
\alias{predict.weightedMeanLearner}
\title{Weighted mean prediction.}
\usage{
\method{predict}{weightedMeanLearner}(object, data, na_rm = FALSE, ...)
}
\arguments{
\item{object}{\code{weightedMeanLearner(1)} \cr
An object from class \link{weightedMeanLearner}}

\item{data}{\code{data.frame} \cr
\code{data.frame} to be predicted.}

\item{na_rm}{\code{boolean} \cr
Removes NAs when TRUE.}

\item{...}{\code{any} \cr
Further arguments.}
}
\value{
Predicted target values are returned.
}
\description{
Predict function for models from class \code{weightedMeanLearner}.
}
\examples{
set.seed(20240625)
x <- data.frame(x1 = rnorm(50L))
y <- sample(x = 0:1, size = 50L, replace = TRUE)
my_model <- weightedMeanLearner(x = x, y = y)
x_new <- data.frame(x1 = rnorm(10L))
my_predictions <- predict(object = my_model, data = x_new)

}
