% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/futurize_options.R
\name{futurize_options}
\alias{futurize_options}
\title{Options for how futures are partitioned and resolved}
\usage{
futurize_options(
  seed = FALSE,
  globals = TRUE,
  packages = NULL,
  stdout = TRUE,
  conditions = "condition",
  scheduling = 1,
  chunk_size = NULL,
  ...
)
}
\arguments{
\item{seed}{(optional) If TRUE, the random seed, that is, the state of the
random number generator (RNG) will be set such that statistically sound
random numbers are produced (also during parallelization).
If FALSE (default), it is assumed that the future expression neither
needs nor uses random number generation.
To use a fixed random seed, specify a L'Ecuyer-CMRG seed (seven integers)
or a regular RNG seed (a single integer).  If the latter, then a
L'Ecuyer-CMRG seed will be automatically created based on the given seed.
Furthermore, if FALSE, then the future will be monitored to make sure it
does not use random numbers.  If it does and depending on the value of
option \link[future]{future.rng.onMisuse}, the check is
ignored, an informative warning, or error will be produced.
If \code{seed} is NULL, then the effect is as with \code{seed = FALSE}
but without the RNG check being performed.}

\item{globals}{(optional) a logical, a character vector, or a named list
to control how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link[future:future]{future()}}.}

\item{packages}{(optional) a character vector specifying packages
to be attached in the \R environment evaluating the future.}

\item{stdout}{If TRUE (default), then the standard output is captured,
and re-outputted when \code{value()} is called.
If FALSE, any output is silenced (by sinking it to the null device as
it is outputted).
Using \code{stdout = structure(TRUE, drop = TRUE)} causes the captured
standard output to be dropped from the future object as soon as it has
been relayed. This can help decrease the overall memory consumed by
captured output across futures.
Using \code{stdout = NA} fully avoids intercepting the standard output;
behavior of such unhandled standard output depends on the future backend.}

\item{conditions}{A character string of condition classes to be captured
and relayed.  The default is to relay all conditions, including messages
and warnings.  To drop all conditions, use \code{conditions = character(0)}.
Errors are always relayed.
Attribute \code{exclude} can be used to ignore specific classes, e.g.
\code{conditions = structure("condition", exclude = "message")} will capture
all \code{condition} classes except those that inherit from the \code{message} class.
Using \code{conditions = structure(..., drop = TRUE)} causes any captured
conditions to be dropped from the future object as soon as they have
been relayed, e.g. by \code{value(f)}. This can help decrease the overall
memory consumed by captured conditions across futures.
Using \code{conditions = NULL} (not recommended) avoids intercepting conditions,
except from errors; behavior of such unhandled conditions depends on the
future backend and the environment from which R runs.}

\item{scheduling}{Average number of futures ("chunks") per worker.
If \code{0.0}, then a single future is used to process all elements
of \code{X}.
If \code{1.0} or \code{TRUE}, then one future per worker is used.
If \code{2.0}, then each worker will process two futures
(if there are enough elements in \code{X}).
If \code{Inf} or \code{FALSE}, then one future per element of
\code{X} is used.
Only used if \code{chunk_size} is \code{NULL}.}

\item{chunk_size}{The average number of elements per future ("chunk").
If \code{Inf}, then all elements are processed in a single future.
If \code{NULL}, then argument \code{scheduling} is used.}

\item{\ldots}{Additional named options.}
}
\value{
A named list of future options.
Attribute \code{specified} is a character vector of future options
that were explicitly specified.
}
\description{
Options for how futures are partitioned and resolved
}
\examples{
# Default futurize options
str(futurize_options())

}
