% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt_fuzzy_join_cpp.R
\name{fuzzystring_join_backend}
\alias{fuzzystring_join_backend}
\title{Fuzzy join backend using 'data.table' + 'C++' row binding}
\usage{
fuzzystring_join_backend(
  x,
  y,
  by = NULL,
  match_fun = NULL,
  multi_by = NULL,
  multi_match_fun = NULL,
  index_match_fun = NULL,
  mode = "inner",
  ...
)
}
\arguments{
\item{x}{A \code{data.frame} or \code{data.table}.}

\item{y}{A \code{data.frame} or \code{data.table}.}

\item{by}{Columns by which to join the two tables. See
\code{\link{fuzzystring_join}}.}

\item{match_fun}{A function used to match values. It must return a logical
vector (or a data.frame/data.table whose first column is logical) indicating
which pairs match. For multi-column joins, you may pass a list of functions
(one per column).}

\item{multi_by}{A character vector of column names used for multi-column
matching when \code{multi_match_fun} is supplied.}

\item{multi_match_fun}{A function that receives matrices of unique values for
\code{x} and \code{y} (rows correspond to unique combinations of \code{multi_by}).
It must return a logical vector (or a data.frame/data.table whose first column
is logical) indicating which rows match.}

\item{index_match_fun}{A function that receives the joined columns from
\code{x} and \code{y} and returns a table with integer columns \code{x} and
\code{y} (1-based row indices).}

\item{mode}{One of \code{"inner"}, \code{"left"}, \code{"right"}, \code{"full"},
\code{"semi"}, or \code{"anti"}.}

\item{...}{Additional arguments passed to the matching function(s).}
}
\value{
A joined table (same container type as \code{x}). See
\code{\link{fuzzystring_join}}.
}
\description{
Low-level engine used by \code{\link{fuzzystring_join}} and the 'C++'-optimized
fuzzy join helpers. It builds the match index with R 'data.table' and then
assembles the result using a compiled 'C++' binder for speed.
}
\details{
This function works like \code{\link{fuzzystring_join}}, but replaces the
R-based row binding with a 'C++' implementation. This provides better performance,
especially for large joins with many matches. It is intended as a backend and
does not compute distances itself; use \code{\link{fuzzystring_join}} for
string-distance based matching.

The C++ implementation handles:
\itemize{
\item Efficient subsetting by row indices
\item Proper handling of NA values in outer joins
\item Type-safe column operations for all common R types
\item Preservation of factor levels and attributes
\item Column name conflicts with .x/.y suffixes
}
}
\keyword{internal}
