% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{g6_nodes}
\alias{g6_nodes}
\alias{g6_edges}
\alias{g6_combos}
\alias{validate_elements}
\alias{validate_elements.g6_nodes}
\alias{validate_elements.g6_edges}
\alias{validate_elements.g6_combos}
\alias{as_g6_nodes.g6_nodes}
\alias{as_g6_nodes.data.frame}
\alias{as_g6_nodes.list}
\title{Create and validate lists of G6 elements}
\usage{
g6_nodes(...)

g6_edges(...)

g6_combos(...)

validate_elements(x, ...)

\method{validate_elements}{g6_nodes}(x, ...)

\method{validate_elements}{g6_edges}(x, ...)

\method{validate_elements}{g6_combos}(x, ...)

\method{as_g6_nodes}{g6_nodes}(x, ...)

\method{as_g6_nodes}{data.frame}(x, ...)

\method{as_g6_nodes}{list}(x, ...)
}
\arguments{
\item{...}{Additional arguments (unused).}

\item{x}{An object of class \code{g6_nodes}, \code{g6_edges}, or \code{g6_combos}.}
}
\value{
An object of class \code{g6_nodes}, \code{g6_edges}, or \code{g6_combos}.

Invisibly returns the validated object.
}
\description{
Constructors for lists of G6 node, edge, and combo elements.
Each function accepts multiple validated elements and returns a
list with the appropriate class.
All elements are validated on construction.

S3 generic for validating lists of G6 elements.
}
\examples{
nodes <- g6_nodes(
  g6_node(id = "n1"),
  g6_node(id = "n2")
)
edges <- g6_edges(
  g6_edge(source = "n1", target = "n2")
)
combos <- g6_combos(
  g6_combo(id = "c1")
)
}
