% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_search.R
\name{gemini_search}
\alias{gemini_search}
\title{Generate text with real-time information using Google Search (Grounding)}
\usage{
gemini_search(
  prompt,
  temperature = 1,
  maxOutputTokens = 8192,
  topK = 40,
  topP = 0.95,
  seed = 1234
)
}
\arguments{
\item{prompt}{The prompt or question requiring real-time information}

\item{temperature}{The temperature to use. Default is 1 value should be between 0 and 2
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{maxOutputTokens}{The maximum number of tokens to generate.
Default is 8192 and 100 tokens correspond to roughly 60-80 words.}

\item{topK}{The top-k value to use. Default is 40 value should be between 0 and 100
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{topP}{The top-p value to use. Default is 0.95 value should be between 0 and 1
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{seed}{The seed to use. Default is 1234 value should be integer
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}
}
\value{
Generated text with real-time information from Google Search
}
\description{
Generate text responses that include up-to-date information from Google Search
}
\details{
The API key is now sent via the HTTP header \code{x-goog-api-key} instead of as a URL query parameter.
}
\examples{
\dontrun{
library(gemini.R)
setAPI("YOUR_API_KEY")
gemini_search("What is the current Google stock price?")
}
}
\seealso{
https://ai.google.dev/gemini-api/docs/google-search
}
