% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nano_banana.R
\name{nano_banana}
\alias{nano_banana}
\title{Generate, edit, or transfer images using Gemini API}
\usage{
nano_banana(
  prompt,
  type = "generate",
  img_path = NULL,
  img_path2 = NULL,
  output_path
)
}
\arguments{
\item{prompt}{Character. The prompt describing the image to generate or edit.}

\item{type}{Character. The type of operation: "generate" (text-to-image), "edit" (image editing), "transfer" (image-to-image).}

\item{img_path}{Character. Path to the input image PNG file.}

\item{img_path2}{Character. Path to the second input image PNG file.}

\item{output_path}{Character. The filename to save the result image.}
}
\value{
The path to the saved image file, or NULL if an error occurred.
}
\description{
Generate a new image, edit an existing image, or transfer styles/content between two images using the Gemini API (aka Nano Banana).
This function supports image generation from text, image editing with a prompt and a base image, and image transfer between two images.
}
\examples{
\dontrun{
# Generate an image from text
prompt <- "Create a picture of a nano banana dish in a fancy restaurant with a Gemini theme"
nano_banana(prompt, output_path = "gemini-native-image.png")

# Edit an image with a prompt (continued from generate)
prompt <- paste(
  "Create a picture of my cat eating a nano-banana",
  "in a restaurant under the Gemini constellation"
)
nano_banana(
  prompt,
  type = "edit",
  img_path = "gemini-native-image.png",
  output_path = "edited_image.png"
)

# Transfer style/content between two images
prompt <- paste(
  "Take the blue floral dress from the first image",
  "and let the woman from the second image wear it."
)
nano_banana(
  prompt,
  type = "transfer",
  img_path = "dress.png",
  img_path2 = "model.png",
  output_path = "transferred_image.png"
)
}
}
