% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_legend}
\alias{GC_legend}
\title{Set Legend for a Gene Chart}
\usage{
GC_legend(
  GC_chart,
  group = NULL,
  show = TRUE,
  backgroundColor = "#0000",
  order = list(),
  position = "bottom",
  style = list(),
  legendOptions = list(),
  legendTextOptions = list(),
  ...
)
}
\arguments{
\item{GC_chart}{The gene chart object to be modified.}

\item{group}{Optional; character or NULL, specifies the groups to include in
the legend. If NULL, groups are taken from the 'group' attribute of the
'GC_chart' object.}

\item{show}{Logical, specifies whether to display the legend.}

\item{backgroundColor}{String, the background color of the legend.}

\item{order}{Optional; list, specifies the order of the legend labels.}

\item{position}{Character. Position of the legend, either "top" or "bottom".
Default is "bottom".}

\item{style}{A list of CSS styles to be applied to the chart container. Each
element of the list should be a valid CSS property-value pair. For example,
list(backgroundColor = "white", border = "2px solid black"). Default is an
empty list.}

\item{legendOptions}{List, additional options for the legend.}

\item{legendTextOptions}{List, additional text options for the legend.}

\item{...}{Additional arguments to be passed to the legend configuration.}
}
\value{
Returns the modified gene chart object with the legend configured.
}
\description{
This function configures the legend for a gene chart. It allows toggling the
legend's visibility, setting a background color, and assigning custom labels
for the legend entries. The function can also handle additional
customizations through various options.
}
\examples{
genes_data <- data.frame(
  start = c(10, 90, 130, 170, 210),
  end = c(40, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'B', 'B', 'A', 'C'),
  cluster = c('A', 'A', 'A', 'B', 'B')
)

# Customize legend
GC_chart(genes_data, cluster = "cluster", group = "group", height = "200px") \%>\%
  GC_legend(
    position = "top", #bottom
    orientation = "horizontal", #vertical
    x = 0,
    y = 0,
    adjustHeight = TRUE,
    backgroundColor = "#0000",
    order = list(),
    style = list(
      backgroundColor = "#0000"
      # Any other CSS styles
    ),
    legendOptions = list(
      cursor = "pointer",
      colorScheme = NULL,
      customColors = NULL # c("red", "green", "orange")
      # Additional styles
    ),
    legendTextOptions = list(
      cursor = "pointer",
      textAnchor = "start",
      dy = ".35em",
      fontSize = "12px",
      fontFamily = "sans-serif",
      fill = "black"
      # Additional styles
    )
  )

}
