% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localcartesian.R
\name{localcartesian_fwd}
\alias{localcartesian_fwd}
\alias{localcartesian_rev}
\title{Local Cartesian (ENU) coordinate system}
\usage{
localcartesian_fwd(x, lon0, lat0, h = 0, h0 = 0)

localcartesian_rev(x, y, z, lon0, lat0, h0 = 0)
}
\arguments{
\item{x}{For forward conversion: a two-column matrix or data frame of
coordinates (longitude, latitude) in decimal degrees, or a list with
longitude and latitude components. Can also be a length-2 numeric vector
for a single point.
For reverse conversion: numeric vector of x (east) coordinates in meters.}

\item{lon0}{Longitude of the origin in decimal degrees.}

\item{lat0}{Latitude of the origin in decimal degrees.}

\item{h}{Numeric vector of heights above the ellipsoid in meters. Default is 0.}

\item{h0}{Height of the origin above the ellipsoid in meters. Default is 0.}

\item{y}{Numeric vector of y (north) coordinates in meters.}

\item{z}{Numeric vector of z (up) coordinates in meters.}
}
\value{
\itemize{
\item \code{localcartesian_fwd()}: Data frame with columns:
\itemize{
\item \code{x}: East coordinate in meters
\item \code{y}: North coordinate in meters
\item \code{z}: Up coordinate in meters
\item \code{lon}, \code{lat}, \code{h}: Input coordinates (echoed)
}
\item \code{localcartesian_rev()}: Data frame with columns:
\itemize{
\item \code{lon}: Longitude in decimal degrees
\item \code{lat}: Latitude in decimal degrees
\item \code{h}: Height above ellipsoid in meters
\item \code{x}, \code{y}, \code{z}: Input coordinates (echoed)
}
}
}
\description{
Convert between geographic coordinates and a local Cartesian coordinate
system centered at a specified origin. The local system uses East-North-Up
(ENU) axes.
}
\details{
The local Cartesian coordinate system is useful for:
\itemize{
\item Local surveys where a flat Earth approximation is valid
\item Converting GPS positions to a local reference frame
\item Robotics and navigation applications
}

The coordinate system is:
\itemize{
\item \strong{x}: positive east
\item \strong{y}: positive north
\item \strong{z}: positive up (away from Earth's center)
}

This is also known as an ENU (East-North-Up) coordinate system.
}
\examples{
# Set up local system centered on London
london <- c(-0.1, 51.5)

# Convert nearby points to local coordinates
pts <- cbind(
  lon = c(-0.1, -0.2, 0.0),
  lat = c(51.5, 51.6, 51.4)
)
localcartesian_fwd(pts, lon0 = london[1], lat0 = london[2])

# Round-trip conversion
fwd <- localcartesian_fwd(pts, lon0 = -0.1, lat0 = 51.5)
localcartesian_rev(fwd$x, fwd$y, fwd$z, lon0 = -0.1, lat0 = 51.5)
}
\seealso{
\code{\link[=geocentric_fwd]{geocentric_fwd()}} for Earth-Centered Earth-Fixed (ECEF) coordinates
}
