% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{geo_match}
\alias{geo_match}
\title{Match Across Geographic Layers}
\usage{
geo_match(
  from,
  to,
  method = "center",
  by = NULL,
  tiebreaker = TRUE,
  epsg = 3857
)
}
\arguments{
\item{from}{smaller geographic level to match up from}

\item{to}{larger geographic level to be matched to}

\item{method}{string from 'center', 'centroid', 'point', 'circle', or 'area' for matching method}

\item{by}{A character vector to match by. One element if both \code{from} and \code{to} share the subsetting column name.
One element with a name (for \code{from}) and one element (for \code{to}).}

\item{tiebreaker}{Should ties be broken? boolean. If FALSE, precincts with no
matches get value -1 and precincts with multiple matches get value -2.}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}
}
\value{
Integer Vector of matches length(to) with values in 1:nrow(from)
}
\description{
Match Across Geographic Layers
}
\details{
Methods are as follows:
\itemize{
\item centroid: matches each element of \code{from} to the \code{to} entry that the geographic centroid intersects
\item center: very similar to centroid, but it matches an arbitrary center point within \code{from}
if the centroid of \code{from} is outside the bounds of from. (This happens for non-convex shapes only).
\item point: matches each element of \code{from} to the \code{to} entry that the "point on surface" intersects.
\item circle: matches each element of \code{from} to the \code{to} entry that the centroid
of the maximum inscribed circle intersects
\item area: matches each element of \code{from} to the \code{to} element which has the largest area overlap
}
}
\examples{
library(dplyr)
data(checkerboard)
counties <- sf::st_as_sf(as.data.frame(rbind(
  sf::st_union(checkerboard |> filter(i < 4)),
  sf::st_union(checkerboard |> filter(i >= 4))
)))

geo_match(from = checkerboard, to = counties)
geo_match(from = checkerboard, to = counties, method = 'area')
}
\concept{estimate}
