% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-water-indices.R
\name{calculate_multiple_water_indices}
\alias{calculate_multiple_water_indices}
\title{Calculate multiple water indices at once}
\usage{
calculate_multiple_water_indices(
  green,
  nir,
  swir1 = NULL,
  indices = c("NDWI", "MNDWI", "NDMI"),
  output_stack = TRUE,
  clamp_values = TRUE,
  mask_invalid = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{green}{Green band SpatRaster or file path}

\item{nir}{NIR band SpatRaster or file path}

\item{swir1}{SWIR1 band SpatRaster or file path}

\item{indices}{Vector of index names to calculate}

\item{output_stack}{Return as single multi-layer raster (TRUE) or list (FALSE)}

\item{clamp_values}{Apply reasonable value clamping}

\item{mask_invalid}{Mask invalid values}

\item{verbose}{Print progress messages}
}
\value{
SpatRaster stack or list of water indices
}
\description{
Calculate multiple water indices from the same spectral data in a single operation.
Efficient for comprehensive water and moisture analysis.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Calculate multiple water indices
water_indices <- calculate_multiple_water_indices(
  green = green_band,
  nir = nir_band,
  swir1 = swir1_band,
  indices = c("NDWI", "MNDWI", "NDMI", "MSI"),
  output_stack = TRUE,
  verbose = TRUE
)

# Access individual indices
ndwi <- water_indices[["NDWI"]]
mndwi <- water_indices[["MNDWI"]]
}

}
