% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vpts.R
\name{get_vpts}
\alias{get_vpts}
\title{Get vertical profile time series (VPTS) data from supported sources}
\usage{
get_vpts(
  radar,
  datetime,
  source = c("baltrad", "uva", "ecog-04003", "rmi"),
  return_type = c("vpts", "tibble")
)
}
\arguments{
\item{radar}{Name of the radar (odim code) as a character string (e.g.
\code{"nlhrw"} or \code{"fikor"}).}

\item{datetime}{Either:
\itemize{
\item A \code{\link[base:DateTimeClasses]{POSIXct}} datetime (or \code{character}
representation), for which the data file is downloaded.
\item A \code{\link[base:Dates]{Date}} date (or \code{character} representation), for which
all data files are downloaded.
\item A vector of datetimes or dates, between which all data files are
downloaded.
\item A \code{\link[lubridate:interval]{lubridate::interval()}}, between which all data files are downloaded.
}}

\item{source}{Source of the data. One of \code{"baltrad"}, \code{"uva"}, \code{"ecog-04003"}
or \code{"rmi"}. Only one source can be queried at a time. If not provided,
\code{"baltrad"} is used.}

\item{return_type}{Type of object that should be returned. Either:
\itemize{
\item \code{"vpts"}: vpts object(s) (default).
\item \code{"tibble"}: a \code{\link[dplyr:reexports]{dplyr::tibble()}}.
}}
}
\value{
Either a vpts object, a list of vpts objects or a tibble. See
\link[bioRad:summary.vpts]{bioRad::summary.vpts} for details.
}
\description{
Gets vertical profile time series data from supported sources and returns it
as a (list of) of \link[bioRad:summary.vpts]{vpts objects} or a
\code{\link[dplyr:reexports]{dplyr::tibble()}}.
}
\details{
For more details on supported sources, see \code{vignette("supported_sources")}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get VPTS data for a single radar and date
get_vpts(radar = "bejab", datetime = "2023-01-01", source = "baltrad")
get_vpts(radar = "bejab", datetime = "2020-01-19", source = "rmi")

# Get VPTS data for multiple radars and a single date
get_vpts(
  radar = c("dehnr", "deflg"),
  datetime = lubridate::ymd("20171015"),
  source = "baltrad"
)

# Get VPTS data for a single radar and a date range
get_vpts(
  radar = "bejab",
  datetime = lubridate::interval(
    lubridate::ymd_hms("2023-01-01 00:00:00"),
    lubridate::ymd_hms("2023-01-02 00:14:00")
  ),
  source = "baltrad"
)
get_vpts("bejab", lubridate::interval("20210101", "20210301"))

# Get VPTS data for a single radar, date range and non-default source
get_vpts(radar = "bejab", datetime = "2016-09-29", source = "ecog-04003")

# Return a tibble instead of a vpts object
get_vpts(
  radar = "chlem",
  datetime = "2023-03-10",
  source = "baltrad",
  return_type = "tibble"
)
\dontshow{\}) # examplesIf}
}
