% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ag_layers.R
\name{ag_sequential}
\alias{ag_sequential}
\title{Create a sequential container of layers}
\usage{
ag_sequential(...)
}
\arguments{
\item{...}{Layer objects (ag_linear, ag_dropout, ag_batch_norm, ag_embedding)
or a single list of layers.}
}
\value{
An \code{ag_sequential} environment
}
\description{
Chains layers so that \code{forward(x)} passes \code{x} through each layer
in order.  \code{parameters()} collects all trainable params from all layers.
\code{ag_train()} / \code{ag_eval()} propagate mode to stateful sub-layers.
}
\examples{
\donttest{
model <- ag_sequential(
  ag_linear(4L, 16L, activation = "relu"),
  ag_dropout(0.5),
  ag_linear(16L, 2L, activation = "softmax")
)
x   <- ag_tensor(matrix(runif(4 * 8), 4, 8))
out <- model$forward(x)
}
}
