% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ag_training.R
\name{clip_grad_norm}
\alias{clip_grad_norm}
\title{Clip gradients by global L2 norm}
\usage{
clip_grad_norm(params, grads, max_norm)
}
\arguments{
\item{params}{Named list of ag_param tensors (same as passed to optimizer).}

\item{grads}{Gradient environment returned by \code{backward()}.}

\item{max_norm}{Maximum allowed global L2 norm.}
}
\value{
Numeric: the global L2 norm before clipping (invisibly).
}
\description{
Rescales all gradients in \code{grads} so that their global L2 norm does
not exceed \code{max_norm}.  Modifies the \code{grads} environment
in-place and returns the pre-clip norm.
}
\details{
Call this \strong{after} \code{backward()} and \strong{before}
\code{optimizer$step()}.
}
\examples{
\donttest{
w  <- ag_param(matrix(runif(4), 2, 2))
x  <- ag_tensor(matrix(c(1, 1), 2, 1))
with_grad_tape({
  out  <- ag_matmul(w, x)
  loss <- ag_mse_loss(out, matrix(0, 2, 1))
})
grads <- backward(loss)
clip_grad_norm(list(w = w), grads, max_norm = 1.0)
}
}
