% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_functional.R
\name{ggml_apply}
\alias{ggml_apply}
\title{Apply a Layer Object to a Tensor Node}
\usage{
ggml_apply(tensor, layer)
}
\arguments{
\item{tensor}{A \code{ggml_tensor_node} (e.g. from \code{ggml_input()}).}

\item{layer}{A \code{ggml_layer} object.}
}
\value{
A new \code{ggml_tensor_node}.
}
\description{
Applies a \code{ggml_layer} object (created with \code{ggml_dense()},
\code{ggml_lstm()}, etc.) to a \code{ggml_tensor_node}.  Applying the
\emph{same} layer object to multiple tensor nodes produces shared weights --
the identity of the layer object (\code{layer$layer_id}) is used as the
sharing key, not its name.
}
\examples{
\donttest{
encoder <- ggml_dense(64L, activation = "relu")
x1 <- ggml_input(shape = 32L)
x2 <- ggml_input(shape = 32L)
out1 <- x1 |> ggml_apply(encoder)
out2 <- x2 |> ggml_apply(encoder)  # shared weights
model <- ggml_model(inputs = list(x1, x2),
                    outputs = list(out1, out2))
}
}
