% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_exp}
\alias{ggml_exp}
\title{Exponential (Graph)}
\usage{
ggml_exp(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the exp operation
}
\description{
Creates a graph node for element-wise exponential: exp(x)
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 3)
ggml_set_f32(a, c(0, 1, 2))
result <- ggml_exp(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
output <- ggml_get_f32(result)  # [1, e, e^2]
ggml_free(ctx)
}
}
