% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_model.R
\name{ggml_get_layer}
\alias{ggml_get_layer}
\title{Get a Layer from a Sequential Model}
\usage{
ggml_get_layer(model, index = NULL, name = NULL)
}
\arguments{
\item{model}{A ggml_sequential_model object}

\item{index}{Integer index of the layer (1-based), or NULL}

\item{name}{Character name of the layer, or NULL}
}
\value{
The layer list object
}
\description{
Retrieves a layer by name or by integer index (1-based).
}
\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_dense(64, activation = "relu", name = "hidden") |>
  ggml_layer_dense(10, activation = "softmax", name = "output")

ggml_get_layer(model, index = 1)
ggml_get_layer(model, name = "output")
}
}
