% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_functional.R, R/nn_layers.R
\name{ggml_layer_conv_2d}
\alias{ggml_layer_conv_2d}
\title{Create a Conv2D Layer Object}
\usage{
ggml_layer_conv_2d(
  model,
  filters,
  kernel_size,
  activation = NULL,
  input_shape = NULL,
  strides = c(1L, 1L),
  padding = "valid",
  name = NULL,
  trainable = TRUE
)

ggml_layer_conv_2d(
  model,
  filters,
  kernel_size,
  activation = NULL,
  input_shape = NULL,
  strides = c(1L, 1L),
  padding = "valid",
  name = NULL,
  trainable = TRUE
)
}
\arguments{
\item{model}{A ggml_sequential_model object}

\item{filters}{Number of output filters}

\item{kernel_size}{Integer or vector of 2 integers for kernel height and width}

\item{activation}{Activation function name: "relu", "sigmoid", "tanh", "softmax", or NULL}

\item{input_shape}{Input shape c(H, W, C) - required for first layer only}

\item{strides}{Integer or vector of 2 integers for stride}

\item{padding}{"valid" (no padding) or "same" (preserve spatial dims)}

\item{name}{Optional character name for the layer.}

\item{trainable}{Logical; whether the layer weights are updated during training.}
}
\value{
A \code{ggml_layer} object.

The model object with the conv_2d layer appended (invisibly).
}
\description{
Create a Conv2D Layer Object

Add 2D Convolution Layer
}
\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_conv_2d(32, c(3,3), activation = "relu",
                     input_shape = c(28, 28, 1))
}
}
