% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_out_prod}
\alias{ggml_out_prod}
\title{Outer Product (Graph)}
\usage{
ggml_out_prod(ctx, a, b)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{First vector tensor}

\item{b}{Second vector tensor}
}
\value{
Matrix tensor representing the outer product
}
\description{
Computes the outer product of two vectors: C = a * b^T
For vectors a[m] and b[n], produces matrix C[m, n].
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 3)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 4)
ggml_set_f32(a, c(1, 2, 3))
ggml_set_f32(b, c(1, 2, 3, 4))
c <- ggml_out_prod(ctx, a, b)  # Result: 3x4 matrix
graph <- ggml_build_forward_expand(ctx, c)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
