% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rayshader.R
\name{ggsegray}
\alias{ggsegray}
\title{Render brain atlas with rgl}
\usage{
ggsegray(
  .data = NULL,
  atlas = dk(),
  label_by = "region",
  text_by = NULL,
  colour_by = "colour",
  palette = NULL,
  na_colour = "darkgrey",
  na_alpha = 1,
  material = list(),
  ...,
  label = deprecated(),
  text = deprecated(),
  colour = deprecated()
)
}
\arguments{
\item{.data}{A data.frame to use for plot aesthetics. Must include a
column called "region" corresponding to regions.}

\item{atlas}{A `ggseg_atlas` object containing 3D vertex mappings, or a
string naming an atlas function (deprecated).}

\item{label_by}{String. Column name used as hover label for each region.}

\item{text_by}{String. Column name for extra hover text shown below the
region label.}

\item{colour_by}{String. Column name mapped to mesh colours.}

\item{palette}{String. Vector of colour names or HEX colours. Can also
be a named numeric vector, with colours as names, and breakpoint for
that colour as the value}

\item{na_colour}{String. Either name, hex of RGB for colour of NA in
colour.}

\item{na_alpha}{Numeric. A number between 0 and 1 to control
transparency of NA-regions.}

\item{material}{Named list of rgl material properties passed to
[rgl::tmesh3d()]. Controls how the mesh surface is shaded.}

\item{...}{Type-specific arguments passed to the atlas method.
See section **Type-specific arguments** below.}

\item{label, text, colour}{`r lifecycle::badge("deprecated")` Use
`label_by`, `text_by`, and `colour_by` instead.}
}
\value{
An object of class `ggsegray` (invisibly), which wraps the
  rgl device ID. Pipe into [pan_camera()], [add_glassbrain()], or
  [set_background()] to modify the scene.
}
\description{
Creates an rgl 3D scene from a brain atlas. Uses the same atlas
preparation pipeline as [ggseg3d()] but outputs to rgl instead of
htmlwidgets. The resulting scene can be piped into [pan_camera()],
[add_glassbrain()], and [set_background()], then rendered with
rayshader's `render_highquality()` or captured with `rgl::snapshot3d()`.
}
\section{Material properties}{

Useful material list entries:
\describe{
  \item{`specular`}{`"black"` (matte) or `"white"` (glossy).}
  \item{`shininess`}{Specular exponent. Higher = tighter highlights.}
  \item{`lit`}{`FALSE` disables lighting.}
  \item{`alpha`}{Transparency, 0 (invisible) to 1 (opaque).}
  \item{`smooth`}{`TRUE` for Gouraud shading, `FALSE` for flat.}
}

See [rgl::material3d()] for the full list.
}

\section{Type-specific arguments}{

Cortical atlases (`cortical_atlas`):
\describe{
  \item{`surface`}{Surface type: `"LCBC"` (default, alias for
    inflated), `"inflated"`, `"semi-inflated"`, `"white"`, `"pial"`.}
  \item{`hemisphere`}{Character vector of hemispheres: `"right"`,
    `"left"`.}
  \item{`edge_by`}{Column name for region boundary edges.}
  \item{`brain_meshes`}{Custom brain mesh data.}
}

Tract atlases (`tract_atlas`):
\describe{
  \item{`tract_color`}{`"palette"` (default) or `"orientation"`
    (direction-based RGB).}
  \item{`tube_radius`}{Tube radius (numeric, default 5).}
  \item{`tube_segments`}{Tube segment count (integer, default 8).}
}
}

\examples{
\dontrun{
ggsegray(hemisphere = "left") |>
  pan_camera("left lateral")

ggsegray(atlas = aseg()) |>
  add_glassbrain(opacity = 0.15) |>
  pan_camera("right lateral") |>
  set_background("black")
}

}
