% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-setup_data.R
\name{setup_data}
\alias{setup_data}
\title{Making a new gimap dataset}
\usage{
setup_data(counts = NULL, pg_ids = NULL, sample_metadata = NULL)
}
\arguments{
\item{counts}{a matrix of data that contains the counts where rows are each
paired_guide target and columns are each sample}

\item{pg_ids}{the pgRNA IDs: metadata associated with the pgRNA constructs
that correspond to the rows of the counts data}

\item{sample_metadata}{metadata associated with the samples of the dataset
that correspond to the columns of the counts data.
Should include a column that has replicate information as well as a column
that contains timepoint information respectively (this will be used for log
 fold calculations). These columns should be factors.}
}
\value{
A special gimap_dataset to be used with the other functions in this
package.
}
\description{
This function allows people to have their data ready to be
 processed by gimap
}
\examples{
\dontrun{

counts <- get_example_data("count", data_dir = tempdir()) \%>\%
  dplyr::select(c(
    "Day00_RepA", "Day05_RepA", "Day22_RepA", "Day22_RepB",
    "Day22_RepC"
  )) \%>\%
  as.matrix()

pg_ids <- get_example_data("count", data_dir = tempdir()) \%>\%
  dplyr::select("id")

sample_metadata <- data.frame(
  col_names = c("Day00_RepA", "Day05_RepA", "Day22_RepA", "Day22_RepB", "Day22_RepC"),
  day = as.numeric(c("0", "5", "22", "22", "22")),
  rep = as.factor(c("RepA", "RepA", "RepA", "RepB", "RepC"))
)

gimap_dataset <- setup_data(
  counts = counts,
  pg_ids = pg_ids,
  sample_metadata = sample_metadata
)
}
}
