% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-lau.R
\encoding{UTF-8}
\name{gisco_get_lau}
\alias{gisco_get_lau}
\title{Local Administrative Units (LAU) dataset}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}.

Copyright:
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/statistical-units}.
}
\usage{
gisco_get_lau(
  year = 2024,
  epsg = 4326,
  cache = deprecated(),
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  country = NULL,
  gisco_id = NULL,
  ext = "gpkg"
)
}
\arguments{
\item{year}{character string or number. Release year of the file. One of
\Sexpr[stage=render,results=rd]{giscoR:::db_values("lau",
"year",TRUE)}.}

\item{epsg}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}

\item{cache}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}. These functions always
cache the result due to the size. See \strong{Caching strategies} section
in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{country}{character vector of country codes. It could be either a
vector of country names, a vector of ISO3 country codes or a vector of
Eurostat country codes. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{gisco_id}{Optional. A character vector of \code{GISCO_ID} LAU values.}

\item{ext}{character. Extension of the file (default \code{"gpkg"}). One of
\Sexpr[stage=render,results=rd]{giscoR:::db_values("lau",
"ext",TRUE)}.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
This dataset shows pan European administrative boundaries down to commune
level. Local Administrative units are equivalent to Communes,
see \code{\link[=gisco_get_communes]{gisco_get_communes()}}.
}
\details{
The Nomenclature of Territorial Units for Statistics (NUTS) and the LAU
nomenclature are hierarchical classifications of statistical regions that
together subdivide the EU economic territory into regions of five different
levels (NUTS 1, 2 and 3 and LAU, respectively, moving from larger to smaller
territorial units).

The LAU classification is not covered by any legislative act. Geographical
extent covers the European Union, EFTA countries, and candidate countries.
The scale of the dataset is 1:100 000.

The data contains the National Statistical agency LAU code which can be
joined to LAU lists as well as a field \code{GISCO_ID} which is a unique
identifier consisting of the Country code and LAU code.

Total resident population figures (31 December) have also been added in
some versions based on the associated LAU lists
}
\section{Note}{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}

\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
\dontrun{

lu_lau <- gisco_get_lau(year = 2024, country = "Luxembourg")

if (!is.null(lu_lau)) {
  library(ggplot2)

  ggplot(lu_lau) +
    geom_sf(aes(fill = POP_DENS_2024)) +
    labs(
      title = "Population Density in Luxembourg",
      subtitle = "Year 2024",
      caption = gisco_attributions()
    ) +
    scale_fill_viridis_b(
      option = "cividis",
      label = \(x) prettyNum(x, big.mark = ",")
    ) +
    theme_void() +
    labs(fill = "pop/km2")
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=gisco_get_communes]{gisco_get_communes()}}.

See \code{\link[=gisco_bulk_download]{gisco_bulk_download()}} to perform a bulk download of datasets.

See \code{\link[=gisco_id_api_lau]{gisco_id_api_lau()}} to download via GISCO ID service API.

Other statistical units datasets:
\code{\link{gisco_get_census}()},
\code{\link{gisco_get_coastal_lines}()},
\code{\link{gisco_get_nuts}()},
\code{\link{gisco_get_urban_audit}()}
}
\concept{stats}
