% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted_glmstarma.R
\name{fitted.glmstarma}
\alias{fitted.glmstarma}
\alias{fitted.dglmstarma}
\title{Fitted values for glmstarma Models}
\usage{
\method{fitted}{glmstarma}(object, drop_init = TRUE)

\method{fitted}{dglmstarma}(object, return_value = c("mean", "dispersion"), drop_init = TRUE)
}
\arguments{
\item{object}{A \code{glmstarma} or \code{dglmstarma} object.}

\item{drop_init}{Logical; if \code{TRUE}, initial first \code{max_time_lag} columns of fitted values are dropped.}

\item{return_value}{Character; return fitted values of the mean model (\code{"mean"}) or the dispersion model (\code{"dispersion"}).}
}
\value{
A matrix of fitted values.
}
\description{
Compute fitted values for \code{glmstarma} and \code{dglmstarma} models.
}
\examples{
\donttest{
dat <- load_data("chickenpox", directory = tempdir())
chickenpox <- dat$chickenpox
population_hungary <- dat$population_hungary
W_hungary <- dat$W_hungary

model_autoregressive <- list(past_obs = rep(1, 7))
fit <- glmstarma(chickenpox, model_autoregressive, W_hungary, family = vpoisson("log"),
                 covariates = list(population = population_hungary))
fitted.values(fit)

mean_model <- list(past_obs = rep(1, 7))
dispersion_model <- list(past_obs = 1)
fit2 <- dglmstarma(chickenpox, mean_model, dispersion_model, mean_family = vquasipoisson("log"),
                   dispersion_link = "log",
                   wlist = W_hungary, 
                   mean_covariates = list(population = population_hungary))
fitted.values(fit2)
fitted.values(fit2, return_value = "dispersion")
}
}
\seealso{
\code{\link{fitted}}, \code{\link{glmstarma}}, \code{\link{dglmstarma}}
}
