% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterReforms.R
\name{sort_W_and_lambdas}
\alias{sort_W_and_lambdas}
\title{Sort the columns of W matrix by sorting the lambda parameters of the second regime to increasing order}
\usage{
sort_W_and_lambdas(p, M, d, params, model = c("GMVAR", "StMVAR", "G-StMVAR"))
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{\describe{
  \item{For \strong{GMVAR} and \strong{StMVAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMVAR} models:}{a size \eqn{(2\times 1)} integer vector specifying the number of \emph{GMVAR type} components \code{M1}
   in the first element and \emph{StMVAR type} components \code{M2} in the second element. The total number of mixture components
   is \code{M=M1+M2}.}
}}

\item{d}{the number of time series in the system.}

\item{params}{a real valued vector specifying the parameter values.
  \describe{
    \item{\strong{For reduced form models:}}{
      Should be size \eqn{((M(pd^2+d+d(d+1)/2+2)-M1-1)\times 1)} and have the form
      \strong{\eqn{\theta}}\eqn{ = }(\strong{\eqn{\upsilon}}\eqn{_{1}},
      ...,\strong{\eqn{\upsilon}}\eqn{_{M}}, \eqn{\alpha_{1},...,\alpha_{M-1},}\strong{\eqn{\nu}}\eqn{)}, where
      \itemize{
        \item \strong{\eqn{\upsilon}}\eqn{_{m}} \eqn{ = (\phi_{m,0},}\strong{\eqn{\phi}}\eqn{_{m}}\eqn{,\sigma_{m})}
        \item \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p})}
        \item and \eqn{\sigma_{m} = vech(\Omega_{m})}, m=1,...,M,
        \item \strong{\eqn{\nu}}\eqn{=(\nu_{M1+1},...,\nu_{M})}
        \item \eqn{M1} is the number of GMVAR type regimes.
      }
    }
    \item{\strong{For structural model:}}{
      Should have the form
      \strong{\eqn{\theta}}\eqn{ = (\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{_{1},...,}\strong{\eqn{\phi}}\eqn{_{M},
      vec(W),}\strong{\eqn{\lambda}}\eqn{_{2},...,}\strong{\eqn{\lambda}}\eqn{_{M},\alpha_{1},...,\alpha_{M-1},}\strong{\eqn{\nu}}\eqn{)},
      where
      \itemize{
        \item\strong{\eqn{\lambda}}\eqn{_{m}=(\lambda_{m1},...,\lambda_{md})} contains the eigenvalues of the \eqn{m}th mixture component.
      }
    }
  }
  Above, \eqn{\phi_{m,0}} is the intercept parameter, \eqn{A_{m,i}} denotes the \eqn{i}th coefficient matrix of the \eqn{m}th
  mixture component, \eqn{\Omega_{m}} denotes the error term covariance matrix of the \eqn{m}:th mixture component, and
  \eqn{\alpha_{m}} is the mixing weight parameter. The \eqn{W} and \eqn{\lambda_{mi}} are structural parameters replacing the
  error term covariance matrices (see Virolainen, 2022). If \eqn{M=1}, \eqn{\alpha_{m}} and \eqn{\lambda_{mi}} are dropped.
  If \code{parametrization=="mean"}, just replace each \eqn{\phi_{m,0}} with regimewise mean \eqn{\mu_{m}}.
  \eqn{vec()} is vectorization operator that stacks columns of a given matrix into a vector. \eqn{vech()} stacks columns
  of a given matrix from the principal diagonal downwards (including elements on the diagonal) into a vector.

  In the \strong{GMVAR model}, \eqn{M1=M} and \strong{\eqn{\nu}} is dropped from the parameter vector. In the \strong{StMVAR} model,
  \eqn{M1=0}. In the \strong{G-StMVAR} model, the first \code{M1} regimes are \emph{GMVAR type} and the rest \code{M2} regimes are
  \emph{StMVAR type}. In \strong{StMVAR} and \strong{G-StMVAR} models, the degrees of freedom parameters in \strong{\eqn{\nu}}
  # should be strictly larger than two.

  The notation is similar to the cited literature.}
}
\value{
Returns the sorted parameter vector (that implies the same reduced form model).
}
\description{
\code{sort_W_and_lambdas} sorts the columns of W matrix by sorting the lambda parameters of
 the second regime to increasing order.
}
\details{
Only structural models are supported (but there is no need to provide
 structural_pars).
 \strong{This function does not sort the constraints of the W matrix but just sorts
 the columns of the W matrix and the lambda parameters.} It is mainly used in the genetic
 algorithm to assist estimation with better identification when the constraints are not
 itself strong for identification of the parameters (but are invariant to different orderings
 of the columns of the W matrix).

 Before using this function, make sure the parameter vector is sortable: the constraints on
 the W matrix is invariant to different orderings of the columns, there are no zero restrictions,
 and there are no constraints on the lambda parameters.
}
\section{Warning}{

 No argument checks!
}

\references{
\itemize{
   \item Virolainen S. 2025. A statistically identified structural vector autoregression with endogenously
          switching volatility regime. \emph{Journal of Business & Economic Statistics}. \strong{43}:1, 44-54.
   \item Virolainen S. in press. A Gaussian and Student’s mixture vector autoregressive model with an application
    to monetary policy shocks. Econometrics and Statistics.
 }
}
\keyword{internal}
