% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaming.R
\name{StreamHandler}
\alias{StreamHandler}
\title{Stream Handler R6 Class}
\description{
Stream Handler R6 Class

Stream Handler R6 Class
}
\details{
Manages streaming responses from Goose
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{process}}{The processx process object}

\item{\code{buffer}}{Accumulated response buffer}

\item{\code{callback}}{Chunk callback function}

\item{\code{error_callback}}{Error callback function}

\item{\code{complete_callback}}{Completion callback function}

\item{\code{max_time}}{Maximum runtime in seconds (Inf = no limit)}

\item{\code{idle_timeout}}{Maximum time in seconds without output (Inf = no limit)
Initialize stream handler}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StreamHandler-new}{\code{StreamHandler$new()}}
\item \href{#method-StreamHandler-start}{\code{StreamHandler$start()}}
\item \href{#method-StreamHandler-monitor}{\code{StreamHandler$monitor()}}
\item \href{#method-StreamHandler-get_response}{\code{StreamHandler$get_response()}}
\item \href{#method-StreamHandler-stop}{\code{StreamHandler$stop()}}
\item \href{#method-StreamHandler-clone}{\code{StreamHandler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamHandler-new"></a>}}
\if{latex}{\out{\hypertarget{method-StreamHandler-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamHandler$new(callback, error_callback, complete_callback)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{callback}}{Function to call with chunks}

\item{\code{error_callback}}{Function for errors}

\item{\code{complete_callback}}{Function for completion
Start streaming process}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamHandler-start"></a>}}
\if{latex}{\out{\hypertarget{method-StreamHandler-start}{}}}
\subsection{Method \code{start()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamHandler$start(
  query,
  session_id = NULL,
  max_time = Inf,
  idle_timeout = Inf
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{The query to execute}

\item{\code{session_id}}{Optional session ID}

\item{\code{max_time}}{Numeric, maximum runtime in seconds (Inf = no limit)}

\item{\code{idle_timeout}}{Numeric, maximum time in seconds without output (Inf = no limit)
Monitor streaming process}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamHandler-monitor"></a>}}
\if{latex}{\out{\hypertarget{method-StreamHandler-monitor}{}}}
\subsection{Method \code{monitor()}}{
Internal loop that reads stdout/stderr, parses chunks, and enforces
\code{max_time} / \code{idle_timeout}.
Get accumulated buffer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamHandler$monitor()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamHandler-get_response"></a>}}
\if{latex}{\out{\hypertarget{method-StreamHandler-get_response}{}}}
\subsection{Method \code{get_response()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamHandler$get_response()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Complete response text
Stop streaming
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamHandler-stop"></a>}}
\if{latex}{\out{\hypertarget{method-StreamHandler-stop}{}}}
\subsection{Method \code{stop()}}{
Kill the underlying streaming process if it is still running.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamHandler$stop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamHandler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StreamHandler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamHandler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
