% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-grafos-NPdif.R
\encoding{UTF-8}
\name{mutate_binary_sequence}
\alias{mutate_binary_sequence}
\title{Binary sequence mutation}
\usage{
mutate_binary_sequence(s, p = 0.1)
}
\arguments{
\item{s}{Sequence consisting of 0 and 1}

\item{p}{Mutation probability.  Defaults to 0.1}
}
\value{
A mutated binary sequence
}
\description{
Mutation of binary sequences for use in the genetic algorithm
}
\details{
This routine takes a binary sequence and it flips ("mutates") each
bit with a fixed probability.  In the genetic algorithm
context, this operation randomly explores regions of
configuration space which are far away from the starting
point, thus trying to avoid local optima.  The fitting
function values of mutated individuals are generically very
poor, and this behavior is to be expected.  Thus, mutation is
not an optimization procedure per se.
}
\examples{
set.seed(1)
s <- sample(0:1, 10, replace = TRUE)  # 0 0 1 1 0 1 1 1 1 0
mutate_binary_sequence(s, p = 0.5)    # 1 1 1 0 0 0 1 1 0 0
mutate_binary_sequence(s, p = 1)      # 1 1 0 0 1 0 0 0 0 1

}
\seealso{
\link{search_cut_genetic} genetic cut-searching algorithm,
\link{crossover_sequences} crossover operation
}
\author{
Cesar Asensio
}
