% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcCost.R
\name{calcCost}
\alias{calcCost}
\title{Function to calculate N_total by the algorithm proposed by Sevin et al. (2004)}
\usage{
calcCost(
  topolo,
  gene_df1_sel,
  gene_df2_sel,
  recom_mat,
  prob_total,
  last_cross = FALSE,
  last_selfing = FALSE
)
}
\arguments{
\item{topolo}{Crossing scheme described by topology of tree}

\item{gene_df1_sel}{Parental set of crossing}

\item{gene_df2_sel}{Parental set of crossing}

\item{recom_mat}{Matrix of recombination rate among genes.}

\item{prob_total}{Probability of success.}

\item{last_cross}{Whether or not to conduct the last cross to a cultivar without target alleles.}

\item{last_selfing}{Whether or not to conduct the last selfing.}
}
\value{
`calCost` function returns the list of  `n_plant_df`, `gene_df1_sel` and `gene_df2_sel`.
`n_plant_df` contains the information about the number of progenies should be produced at each crossing (node in the tree).
}
\description{
Function to calculate N_total by the algorithm proposed by Sevin et al. (2004)
}
