% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcCostAll.R
\name{calcCostAll}
\alias{calcCostAll}
\title{Function to calculate the number of necessary individuals and generations as the crossing cost for all the crossing schemes.
This is the wrapper function of calCost.}
\usage{
calcCostAll(
  line_comb_lis,
  gene_df1,
  gene_df2,
  recom_mat,
  prob_total,
  last_cross = FALSE,
  last_selfing = FALSE
)
}
\arguments{
\item{line_comb_lis}{A list of combinations of parents.}

\item{gene_df1}{Data frame of one set of haplotype. Values take 1 (target allele) or 0 (non-target).}

\item{gene_df2}{Data frame of the other set of haplotype. Values take 1 or 0.}

\item{recom_mat}{Matrix of recombination rate among genes.}

\item{prob_total}{Probability of success.}

\item{last_cross}{Whether or not to conduct the last cross to a cultivar without target alleles.}

\item{last_selfing}{Whether or not to conduct the last selfing.}
}
\value{
calcCostAll function returns a `gpyramid_all` object. This is a named list with the following components:
* `cost_all` (`data frame`): Data frame showing the number of necessary generations (n_generation) and
the number of individuals (N_total) for each crossing scheme. The crossing schemes are identified by cross_id.
* Other components mirror the input parameters for downstream analysis.
}
\description{
Function to calculate the number of necessary individuals and generations as the crossing cost for all the crossing schemes.
This is the wrapper function of calCost.
}
