% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicStuff.R
\name{B}
\alias{B}
\title{Create Lagged or Lead Variables for Time Series Regression}
\usage{
B(x, k, ...)
}
\arguments{
\item{x}{A numeric vector or time series variable to be lagged or lead}

\item{k}{An integer specifying the lag order:
\itemize{
  \item Positive values (e.g., `k = 1`) create lags (past values)
  \item Negative values (e.g., `k = -1`) create leads (future values)
  \item Zero (`k = 0`) returns the original variable unchanged
}}

\item{...}{Parameters passed to `xregExpander()`.}
}
\value{
A numeric vector of the same length as `x`. The missing values
are treated by the `xregExpander()`. By default they are extrapolated
(\code{gaps="auto"}).
}
\description{
`B()` acts as a backshift operator and creates lagged (past values) or
lead (future values) versions of a variable for use in regression formulas.
This function is designed to work within R formula syntax, similar
to how `I()` or `log()` work.
}
\details{
The function calls for the `xregExpander()` to create lags/leads. So, you can pass
additional parameters to it via ellipsis.


When `k > 0` (lag), the function shifts values forward in time, so `B(x, 1)`
at time `t` contains the value of `x` at time `t-1`.

When `k < 0` (lead), the function shifts values backward in time, so `B(x, -1)`
at time `t` contains the value of `x` at time `t+1`.
}
\examples{
# Create sample time series data
y = rnorm(10)

# Create lags
B(y, 1)

# Create leads
B(y, -1)


}
\seealso{
,
\code{\link[greybox]{xregExpander}} for data frame lag operations
\code{\link[stats]{lag}} for time series lag (different behavior)
}
