% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmtree-fscores.R
\name{fscores_grmtree}
\alias{fscores_grmtree}
\title{Compute Latent Factor Scores for Each Terminal Node in a GRM Tree}
\usage{
fscores_grmtree(grmtree_obj, method = "EAP")
}
\arguments{
\item{grmtree_obj}{A GRM tree object (from \code{grmtree()} function) containing
fitted models in its terminal nodes.}

\item{method}{Scoring method to use: "EAP" (default), "MAP", "ML", or "WLE".
See \code{mirt::fscores()} for details.}
}
\value{
A named list where each element contains the factor scores for a
terminal node. Names correspond to node IDs. Returns NULL for nodes where
computation fails. If no scores can be computed for any node, returns NULL
with a warning.
}
\description{
This function calculates latent factor scores for each terminal node in a GRM
tree object using specified scoring method (EAP, MAP, ML, or WLE).
}
\examples{
\donttest{
  library(grmtree)
  library(hlt)
  data("asti", package = "hlt")
  asti$resp <- data.matrix(asti[, 1:4])

  # Fit GRM tree with gender and group as partitioning variables
  tree <- grmtree(resp ~ gender + group,
          data = asti,
          control = grmtree.control(minbucket = 30))

# Compute EAP scores for all terminal nodes
node_scores <- fscores_grmtree(tree)

# Compute MAP scores instead
node_scores_map <- fscores_grmtree(tree, method = "MAP")
}

}
\seealso{
\code{\link[mirt]{fscores}} for factor scoring methods,
\code{\link{grmtree}} fits a Graded Response Model Tree,
\code{\link{grmforest}} for GRM Forests, \code{\link{threshpar_grmtree}} for
extracting threshold parameters, \code{\link{discrpar_grmtree}} for
extracting discrimination parameters, \code{\link{itempar_grmtree}} for
extracting item parameters, \code{\link{generate_node_scores_dataset}}
generates combined dataset with node assignments and factor scores
}
