% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html-helpers.R
\name{gt_badge}
\alias{gt_badge}
\title{Add a 'badge' based on values and palette}
\usage{
gt_badge(
  gt_object,
  column,
  palette = NULL,
  alpha = 0.2,
  rows = gt::everything()
)
}
\arguments{
\item{gt_object}{An existing \code{gt} table object}

\item{column}{The column to convert to badges, accepts \code{tidyeval}}

\item{palette}{Name of palette as a string. Must be either length of 1 or a vector of valid color names/hex values of equal length to the unique levels of the column (ie if there are 4 names, there need to be 4x colors). Note that if you would like to specify a specific color to match a specific icon, you can also use a named vector like: \code{c("angle-double-up" = "#009E73", "angle-double-down" = "#D55E00","sort" = "#000000")}}

\item{alpha}{A numeric indicating the alpha/transparency. Range from 0 to 1}

\item{rows}{The rows to apply the badge to, accepts \code{tidyeval}. Defaults to all rows.}
}
\value{
\code{gt} table
}
\description{
Add a 'badge' based on values and palette
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
head(mtcars) \%>\%
  dplyr::mutate(cyl = paste(cyl, "Cyl")) \%>\%
  gt() \%>\%
  gt_badge(cyl, palette = c("4 Cyl"="red","6 Cyl"="blue","8 Cyl"="green"))
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{gt_badge.png}{options: width=500}}
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_border}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_merge_stack_color}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
