% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_theme_dot_matrix.R
\name{gt_theme_dot_matrix}
\alias{gt_theme_dot_matrix}
\title{Apply dot matrix theme to a gt table}
\usage{
gt_theme_dot_matrix(gt_object, ..., color = "#b5dbb6", quiet = FALSE)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{...}{Additional arguments passed to \code{gt::tab_options()}}

\item{color}{A string indicating the color of the row striping, defaults to a light green. Accepts either named colors or hex colors.}

\item{quiet}{A logical to silence the warning about missing ID}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Apply dot matrix theme to a gt table
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
themed_tab <- head(mtcars) \%>\%
  gt() \%>\%
  gt_theme_dot_matrix() \%>\%
  tab_header(title = "Styled like dot matrix printer paper")
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{gt_dot_matrix.png}{options: width=500}}
}

\seealso{
Other Themes: 
\code{\link{gt_plt_bullet}()},
\code{\link{gt_plt_conf_int}()},
\code{\link{gt_plt_dot}()},
\code{\link{gt_theme_538}()},
\code{\link{gt_theme_dark}()},
\code{\link{gt_theme_espn}()},
\code{\link{gt_theme_excel}()},
\code{\link{gt_theme_guardian}()},
\code{\link{gt_theme_nytimes}()},
\code{\link{gt_theme_pff}()}
}
\concept{Themes}
