% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_theme_espn.R
\name{gt_theme_espn}
\alias{gt_theme_espn}
\title{Apply ESPN theme to a gt table}
\usage{
gt_theme_espn(gt_object, ...)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{...}{Optional additional arguments to \code{gt::table_options()}}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Apply ESPN theme to a gt table
}
\section{Figures}{

\if{html}{\figure{gt_espn.png}{options: width=500}}
}

\section{Function ID}{

1-2
}

\examples{

library(gt)
themed_tab <- head(mtcars) \%>\%
  gt() \%>\%
  gt_theme_espn()
}
\seealso{
Other Themes: 
\code{\link{gt_plt_bullet}()},
\code{\link{gt_plt_conf_int}()},
\code{\link{gt_plt_dot}()},
\code{\link{gt_theme_538}()},
\code{\link{gt_theme_dark}()},
\code{\link{gt_theme_dot_matrix}()},
\code{\link{gt_theme_excel}()},
\code{\link{gt_theme_guardian}()},
\code{\link{gt_theme_nytimes}()},
\code{\link{gt_theme_pff}()}
}
\concept{Themes}
