% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix-func.R
\name{comat}
\alias{comat}
\alias{get_comatrix}
\alias{get_comatrix.default}
\alias{get_comatrix.FitLandDF}
\alias{get_comatrix.igraph}
\title{Calculate Co-Occurrence Matrix}
\usage{
get_comatrix(x, ...)

\method{get_comatrix}{default}(x, ...)

\method{get_comatrix}{FitLandDF}(
  x,
  discrete = equal_discrete(2),
  neighbor = manhattan(1),
  normalize = normalize_glcm,
  ...
)

\method{get_comatrix}{igraph}(
  x,
  values,
  nlevels = length(unique(values)),
  normalize = normalize_glcm,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{object upon which co-occurrence matrix will be calculated}

\item{...}{additional arguments}

\item{discrete}{function that discretizes object}

\item{neighbor}{function that returns TRUE if two numeric vectors are within
acceptable distance of one another or a single-element \code{character} vector
that describes how to identify acceptable neighbors/offsets}

\item{normalize}{function that normalizes the co-occurrence matrix}

\item{values}{named numeric with values corresponding to the nodes in x.}

\item{nlevels}{int number of levels to discretize into}

\item{verbose}{bool}
}
\value{
matrix (co-occurrence matrix)
}
\description{
Calculate generalized co-occurrence matrix from a variety of objects,
currently including fitness landscapes stored as a \code{FitLandDF} instance from
the \code{fitscape} package.
}
\examples{
# create fitness landscape as instance of FitLandDF object
a <- round(runif(64))
a <- array(a, dim = rep(4, 3))
my_landscape <- fitscape::FitLandDF(a)

# calculate co-occurrence matrix using:
#   Manhattan distance of 1
#   discretization into 2 equal-sized buckets
#   normalization: multiply all elements so that sum of matrix equals unity
comat <- get_comatrix(my_landscape,
                      discrete = equal_discrete(2),
                      neighbor = manhattan(1))

# print co-occurrence matrix
print(comat)

}
