% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_interactions_by_step.R
\name{add_interactions_by_step}
\alias{add_interactions_by_step}
\alias{add_interactions_by_step.default}
\title{Add potential relevant interactions using \code{step()}}
\usage{
add_interactions_by_step(model, ...)

\method{add_interactions_by_step}{default}(model, ...)
}
\arguments{
\item{model}{A model object.}

\item{...}{Additional parameters passed to \code{\link[stats:step]{stats::step()}}.}
}
\value{
The stepwise-selected model.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Add potential relevant interactions to a model usind \code{\link[stats:step]{stats::step()}}. The
function extract the formula of the model, identifies all potential
interactions and pass them as the \strong{upper} component of the \code{scope} argument
to \code{\link[stats:step]{stats::step()}}. The current model formula is passed as the \strong{lower}
component of \code{scope}.
}
\examples{
mod <- glm(as.factor(Survived) ~ ., data = titanic, family = binomial())
mod |> add_interactions_by_step()
}
\keyword{models}
