% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.r
\name{h5_dim}
\alias{h5_dim}
\title{Get Dimensions of an HDF5 Object or Attribute}
\usage{
h5_dim(file, name, attr = NULL)
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{name}{Name of the dataset or object.}

\item{attr}{The name of an attribute to check. If \code{NULL} (default), the function
returns the dimensions of the object itself.}
}
\value{
An integer vector of dimensions, or \code{integer(0)} for scalars.
}
\description{
Returns the dimensions of a dataset or an attribute as an integer vector.
These dimensions match the R-style (column-major) interpretation.
}
\examples{
file <- tempfile(fileext = ".h5")

h5_write(matrix(1:10, 2, 5), file, "matrix")
h5_dim(file, "matrix") # 2 5

h5_write(mtcars, file, "mtcars")
h5_dim(file, "mtcars") # 32 11

h5_write(I(TRUE), file, "my_bool")
h5_dim(file, "my_bool") # integer(0)

h5_write(1:10, file, "my_ints")
h5_dim(file, "my_ints") # 10

unlink(file)
}
