% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{createNutsEngine}
\alias{createNutsEngine}
\title{Create a Zigzag-NUTS engine object}
\usage{
createNutsEngine(
  dimension,
  lowerBounds,
  upperBounds,
  seed,
  stepSize,
  mean,
  precision,
  flags = 128L
)
}
\arguments{
\item{dimension}{the dimension of MTN.}

\item{lowerBounds}{a vector specifying the lower bounds.}

\item{upperBounds}{a vector specifying the upper bounds.}

\item{seed}{random seed.}

\item{stepSize}{the base step size for Zigzag-NUTS.}

\item{mean}{the mean vector.}

\item{precision}{the precision matrix.}

\item{flags}{which SIMD instruction set to use. 128 = SSE, 256 = AVX.}
}
\value{
a list whose only element is the Zigzag-NUTS engine object.
}
\description{
Create the C++ object to set up SIMD vectorization for speeding up calculations
for Zigzag-NUTS ("Zigzag-NUTS engine").
}
\examples{
# Create a Zigzag-NUTS engine for a 2D problem
dimension <- 2
lowerBounds <- c(-2, -2)
upperBounds <- c(2, 2)
stepSize <- 0.1
mean <- c(0.5, -0.5)
precision <- matrix(c(2, 0.3, 0.3, 2), nrow = 2)
nuts_engine <- createNutsEngine(dimension, lowerBounds, upperBounds,
                                seed = 456, stepSize, mean, precision)
str(nuts_engine)
}
\seealso{
\code{\link[=setMean]{setMean()}}, \code{\link[=setPrecision]{setPrecision()}}, \code{\link[=zigzagHMC]{zigzagHMC()}}, \code{\link[=createEngine]{createEngine()}}
}
