% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-ma-plt.R
\name{ts_ma_plot}
\alias{ts_ma_plot}
\title{Time Series Moving Average Plot}
\usage{
ts_ma_plot(
  .data,
  .date_col,
  .value_col,
  .ts_frequency = "monthly",
  .main_title = NULL,
  .secondary_title = NULL,
  .tertiary_title = NULL
)
}
\arguments{
\item{.data}{The data you want to visualize. This should be pre-processed and
the aggregation should match the \code{.frequency} argument.}

\item{.date_col}{The data column from the \code{.data} argument.}

\item{.value_col}{The value column from the \code{.data} argument}

\item{.ts_frequency}{The frequency of the aggregation, quoted, ie. "monthly", anything else
will default to weekly, so it is very important that the data passed to this
function be in either a weekly or monthly aggregation.}

\item{.main_title}{The title of the main plot.}

\item{.secondary_title}{The title of the second plot.}

\item{.tertiary_title}{The title of the third plot.}
}
\value{
A list containing the ggplot2 plot object and the summary data table.
}
\description{
This function will produce a \code{ggplot2} plot with facet wrapping. The plot
contains three moving average panels stacked on top of each other using
facet_wrap. The panels show the main time series with moving average, and
two difference calculations: Diff A shows sequential period-over-period percentage changes (e.g., month-over-month or week-over-week), and Diff B shows year-over-year percentage changes.
}
\details{
This function expects to take in a data.frame/tibble. It will return
a list object so it is a good idea to save the output to a variable and extract
from there.
}
\examples{
suppressPackageStartupMessages(library(dplyr))

data_tbl <- ts_to_tbl(AirPassengers) \%>\%
  select(-index)

output <- ts_ma_plot(
  .data = data_tbl,
  .date_col = date_col,
  .value_col = value
)

output$pgrid
output$data_summary_tbl \%>\% tail()

output <- ts_ma_plot(
  .data = data_tbl,
  .date_col = date_col,
  .value_col = value,
  .ts_frequency = "month"
)

output$pgrid
output$data_summary_tbl \%>\% tail()

}
\author{
Steven P. Sanderson II, MPH
}
