% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heaping_indices.R
\name{coale_li}
\alias{coale_li}
\title{Coale-Li Age Heaping Index}
\usage{
coale_li(x, digit = 0, ageMin = 60, ageMax = max(x), terms = 5, weight = NULL)
}
\arguments{
\item{x}{numeric vector of individual ages.}

\item{digit}{integer (0-9) specifying which terminal digit to evaluate
(default 0).}

\item{ageMin}{minimum age to include (default 60).}

\item{ageMax}{maximum age to include (default max(x)).}

\item{terms}{number of terms for moving average smoothing (default 5).}

\item{weight}{optional numeric vector of sampling weights.}
}
\value{
A single numeric value representing the Coale-Li index.
}
\description{
The Coale-Li index was developed to detect age heaping in populations
with high proportions of elderly persons. It compares actual counts at
specific ages to smoothed reference values using moving averages.
}
\details{
Calculate the Coale-Li index for detecting age heaping at older ages.


The method applies double moving averages to create a smooth reference
distribution, then calculates the ratio of observed to expected counts
for ages ending in a specified digit.

Interpretation:
\itemize{
  \item 1.0: no preference for the digit
  \item >1.0: attraction to the digit (heaping)
  \item <1.0: avoidance of the digit
}

This index is particularly useful for evaluating data quality at older ages
(60+) where heaping on round numbers is common.
}
\examples{
# Create age data with heaping at older ages
set.seed(42)
age <- c(sample(60:99, 5000, replace = TRUE),
         rep(seq(60, 90, by = 10), each = 200))  # Add heaping on 0s
coale_li(age, digit = 0)  # Should be > 1
coale_li(age, digit = 5)  # Should be closer to 1

}
\references{
Coale, A. J. and Li, S. (1991). The effect of age misreporting in China
on the calculation of mortality rates at very high ages.
\emph{Demography}, \strong{28}(2), 293-301.
}
\seealso{
\code{\link{kannisto}} for Kannisto's index,
  \code{\link{jdanov}} for Jdanov's index.

Other heaping indices: 
\code{\link{bachi}()},
\code{\link{heaping_indices}()},
\code{\link{jdanov}()},
\code{\link{kannisto}()},
\code{\link{myers}()},
\code{\link{noumbissi}()},
\code{\link{spoorenberg}()},
\code{\link{whipple}()}
}
\author{
Matthias Templ
}
\concept{heaping indices}
