#' Penn World Data
#' 
#' The data was downloaded from \url{https://www.rug.nl/ggdc/productivity/pwt/} and contains information about different economic measures of countries around the world. The dataset has been subset and variable names have been modified for exercise purposes.
#' 
#' @format A data frame with 12810 rows and 14 variables. Each row represents a country in a specific year.
#' \describe{
#'   \item{Country Code}{3-letter ISO country code}
#'   \item{Country}{country name}
#'   \item{Currency Unit}{currency unit}
#'   \item{Year}{year}
#'   \item{Real GDP Expenditure}{expenditure-side real GDP at chained PPPs (in mil. 2017US$)}
#'   \item{Real GDP Output}{output-side real GDP at chained PPPs (in mil. 2017US$)}
#'   \item{Population}{population (in millions)}
#'   \item{Emp}{number of persons engaged (in millions)}
#'   \item{Average Hours}{average annual hours worked by persons engaged}
#'   \item{PL Consumption}{price level of household consumption,  price level of USA GDPo in 2017=1}
#'   \item{PL Capital Formation}{price level of capital formation,  price level of USA GDPo in 2017=1}
#'   \item{PL Gov}{price level of government consumption,  price level of USA GDPo in 2017=1}
#'   \item{PL Exports}{price level of exports, price level of USA GDPo in 2017=1}
#'   \item{PL Imports}{price level of imports, price level of USA GDPo in 2017=1}
#' }
#' @source Feenstra, Robert C., Robert Inklaar and Marcel P. Timmer (2015), "The Next Generation of the Penn World Table" American Economic Review, 105(10), 3150-3182, available for download at \url{http://www.ggdc.net/pwt/}.

"penn_world"