% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lettuce_markers}
\alias{lettuce_markers}
\alias{lettuce_GRM}
\title{Molecular marker data and genomic relatedness matrix of 89 lettuce varieties}
\format{
\subsection{\code{lettuce_markers}}{

A data frame with 89 rows and 301 columns:
\itemize{
\item \code{gen} genotype identifier
\item 300 genetic markers scored as -1, 0, 1 (see Details)
}
}

\subsection{\code{lettuce_GRM}}{

A matrix array with 89 rows and 89 columns where each row/column represents
a genotype
}
}
\source{
\url{https://figshare.com/articles/dataset/Lettuce_trial_phenotypic_and_marker_data_/8299493}
}
\usage{
lettuce_markers

lettuce_GRM
}
\description{
Molecular marker data and genomic relatedness matrix of 89 lettuce varieties
}
\details{
The varieties were genotyped with a total of 300 markers
(i.e. 95 single nucleotide polymorphisms and 205 amplified fragment length
polymorphism markers, see Hayes et al. (2014) for more details of marker
matrix.
The biallelic marker \eqn{M_iw} for the ith genotype and the \eqn{w}th marker with
alleles \eqn{A_1} (i.e. the reference allele) and \eqn{A_2} was coded as:
\itemize{
\item 1 for \eqn{A_1} \eqn{A_1},
\item -1 for \eqn{A_2} \eqn{A_2}
\item 0 for \eqn{A_1} \eqn{A_2} and \eqn{A_2} \eqn{A_1}
}
}
\references{
Hadasch, S., Simko, I., Hayes, R.J., Ogutu, J.O. and Piepho, H.-P. (2016), Comparing the Predictive Abilities of Phenotypic and Marker-Assisted Selection Methods in a Biparental Lettuce Population. The Plant Genome, 9: plantgenome2015.03.0014. \doi{doi:10.3835/plantgenome2015.03.0014}

Hayes, R. J., Galeano, C. H., Luo, Y., Antonise, R., & Simko, I. (2014). Inheritance of Decay of Fresh-cut Lettuce in a Recombinant Inbred Line Population from ‘Salinas 88’ × ‘La Brillante’. Journal of the American Society for Horticultural Science, 139(4), 388–398. \doi{doi:10.21273/JASHS.139.4.388}
}
\keyword{datasets}
