% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_projection.R
\name{hexify_inverse}
\alias{hexify_inverse}
\title{Inverse Snyder projection}
\usage{
hexify_inverse(x, y, face, tol = NULL, max_iters = NULL)
}
\arguments{
\item{x}{X coordinate on face plane}

\item{y}{Y coordinate on face plane}

\item{face}{Face index (0-19)}

\item{tol}{Convergence tolerance (NULL for default)}

\item{max_iters}{Maximum iterations (NULL for default)}
}
\value{
Named numeric vector: c(lon_deg, lat_deg)
}
\description{
Converts face plane coordinates back to geographic coordinates.
}
\examples{
coords <- hexify_inverse(0.5, 0.3, face = 2)
}
\seealso{
Other projection: 
\code{\link{hexify_build_icosa}()},
\code{\link{hexify_face_centers}()},
\code{\link{hexify_forward}()},
\code{\link{hexify_forward_to_face}()},
\code{\link{hexify_get_precision}()},
\code{\link{hexify_projection_stats}()},
\code{\link{hexify_set_precision}()},
\code{\link{hexify_set_verbose}()},
\code{\link{hexify_which_face}()}
}
\concept{projection}
