% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_projection.R
\name{hexify_forward}
\alias{hexify_forward}
\title{Forward Snyder projection}
\usage{
hexify_forward(lon, lat)
}
\arguments{
\item{lon}{Longitude in degrees}

\item{lat}{Latitude in degrees}
}
\value{
Named numeric vector: c(face, tx, ty)
}
\description{
Projects geographic coordinates onto the icosahedron, returning
face index and planar coordinates (tx, ty).
}
\details{
tx and ty are normalized coordinates within the triangular face,
typically in range [0, 1].
}
\examples{
result <- hexify_forward(16.37, 48.21)
# result["face"], result["icosa_triangle_x"], result["icosa_triangle_y"]
}
\seealso{
Other projection: 
\code{\link{hexify_build_icosa}()},
\code{\link{hexify_face_centers}()},
\code{\link{hexify_forward_to_face}()},
\code{\link{hexify_get_precision}()},
\code{\link{hexify_inverse}()},
\code{\link{hexify_projection_stats}()},
\code{\link{hexify_set_precision}()},
\code{\link{hexify_set_verbose}()},
\code{\link{hexify_which_face}()}
}
\concept{projection}
