% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_bsa.R
\name{tar_bsa}
\alias{tar_bsa}
\title{Body surface area calculator in m^2 (DuBois and DuBois formula)}
\usage{
tar_bsa(height, weight)
}
\arguments{
\item{height}{A numeric value in cm}

\item{weight}{A numeric value in kg}
}
\value{
A numeric value in m^2
}
\description{
This function calculates the body surface area with the
DuBois method. DuBois D. A formula to estimate the approximate surface
area if height and body mass are known. Arch Intern Med 1916;17:863-71.
}
\examples{
tar_bsa(height = 180, weight = 80) # ~1.996421 m^2

}
