% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibdCluster.R
\name{.ibdCluster}
\alias{.ibdCluster}
\title{Cluster individuals by local IBD-like similarity in sliding windows}
\usage{
.ibdCluster(genotype, cpus, windowsSize, maxOH)
}
\arguments{
\item{genotype}{A numeric matrix of genotypes with individuals in rows and
markers/SNPs in columns. This function treats genotype code `1` (heterozygote)
as missing by converting it to `9` prior to calling the native routine.}

\item{cpus}{Integer scalar. Requested number of CPU threads. The underlying
C++ implementation uses OpenMP; the actual number of threads may depend on
how R and your compiler toolchain were built and configured.}

\item{windowsSize}{Integer scalar giving the window size (in markers). Must
be between 1 and \code{ncol(genotype)}. Internally, the native routine uses
a 0-based offset window length of \code{windowsSize - 1}.}

\item{maxOH}{Integer scalar. Maximum allowed opposing-homozygote
count (or a similar mismatch threshold) used by the native grouping
algorithm within each window.}
}
\value{
A list (R "list" object) of length \code{ncol(genotype) - (windowsSize - 1)}.
Each element corresponds to one sliding window position and contains an
integer vector of group assignments produced by the native implementation.
(Exact encoding of groups is defined by the underlying \code{mhMat} grouping
routine.)
}
\description{
Internal helper that applies a sliding-window clustering procedure across a
genotype matrix. For each window of markers, individuals are grouped using
an opposing-homozygote style criterion (controlled by \code{maxOH}) via a
native C++ routine.
}
\details{
This function is a thin R wrapper around the native routine
\code{ibdCluster} implemented in C++ and called via \code{.Call()}.


The function scans windows of consecutive markers. For each window starting
at marker \code{i}, it clusters individuals based on the submatrix
\code{genotype[, i:(i+windowsSize-1)]} after recoding heterozygotes (`1`) to
missing (`9`). Computation is parallelized in C++ using OpenMP across window
start positions.
}
\keyword{internal}
