% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prCalus.R
\name{.prCalus}
\alias{.prCalus}
\title{Calus-style recursive clustering of individuals using an OH matrix}
\usage{
.prCalus(oh, genotype)
}
\arguments{
\item{oh}{A numeric matrix representing the opposing-homozygotes (OH) counts
between individuals. Row and column names should be individual IDs. The
matrix is expected to be square and symmetric.}

\item{genotype}{A numeric genotype matrix of dimension \eqn{n \times m}
(individuals \eqn{\times} SNPs), coded as 0 (AA), 1 (AB), 2 (BB), and 9 for
missing values (as used in \code{hsphase}).}
}
\value{
A \code{data.frame} with columns:
\describe{
  \item{id}{Individual ID (character).}
  \item{group}{An integer-like group code (generated randomly; not reproducible).}
}
}
\description{
Performs a recursive hierarchical clustering on an opposing-homozygotes (OH)
matrix to split individuals into two groups at each step (Ward clustering),
until within-group OH values fall below a threshold derived from allele
frequencies estimated from the genotype matrix.
}
\details{
The function returns a two-column data frame containing individual IDs and an
assigned group code. Group codes are generated randomly (via \code{rnorm()})
and therefore are not stable across runs.


The threshold \code{maxsnpnooh} is computed from per-SNP minor allele
frequencies (\code{.maf}) and then reduced by 10\%. The recursion proceeds as:
\enumerate{
  \item Compute pairwise distances from \code{oh} using \code{.fastdist} and
  convert to a \code{dist} object.
  \item Apply hierarchical clustering (\code{\link[stats]{hclust}} with
  \code{method = "ward.D"}).
  \item Cut the dendrogram into \code{k = 2} groups.
  \item For each group, compute the maximum within-group OH value; if it
  exceeds \code{maxsnpnooh} and group size is > 2, recurse into that subgroup.
  Otherwise, write group assignments to a temporary file and stop recursion.
}
}
\section{Side effects}{

This function writes to and reads from a file named \code{"temp.txt"} in the
current working directory, and then deletes it.
}

\seealso{
\code{\link[stats]{hclust}}, \code{\link[stats]{cutree}},
  \code{\link[stats]{as.dist}}
}
\keyword{internal}
