% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_dermal_equiv.R
\name{calc_dermal_equiv}
\alias{calc_dermal_equiv}
\title{Calculate Dermal Equivalent Dose}
\usage{
calc_dermal_equiv(
  conc,
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  parameters = NULL,
  days = 20,
  doses.per.day = 3,
  skin_depth = 0.3,
  skin.pH = 7,
  Vmedia = 0.001,
  Fskinexposed = 0.1,
  ...
)
}
\arguments{
\item{conc}{Bioactive in vitro concentration, arbitrary units.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{chem.cas}{Either the CAS number or the chemical name must be
specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from parameterize_dermal_pbtk.}

\item{days}{Number of days of simulation.}

\item{doses.per.day}{Number of doses per day.}

\item{skin_depth}{Skin depth, cm.}

\item{skin.pH}{pH of skin/dermis.}

\item{Vmedia}{Volume of media, L, used when parameters are not given.}

\item{Fskinexposed}{Fraction of total skin exposed, used when parameters are
not given.}

\item{...}{Additional parameters passed to solve_dermal_pbtk.}
}
\value{
Equivalent dose in specified units, default of mg/kg BW/day.
}
\description{
This functions converts a steady state plasma concetration for a given
dermal exposure scenario to an equivalent steady state media concentration
for a single dose.
}
\details{
Returned dose is dependent on doses.per.day.
}
\author{
Annabel Meade
}
